function [x] = naca4_generator(name,n)
% NACA4_GENERATOR genera un profilo NACA a 4 cifre
% Scritto da Pavan Andrea - 18/04/2019
%       [x] = naca4_generator(name,n)
% INPUT:
%       name: nome profilo (es: '4412')
%       n: numero pannelli (es: 100)
% OUTPUT:
%       x: matrice (n+1)x2 dei punti

m = str2double(name(1))/100;
p = str2double(name(2))/10;
t = str2double(name(3:4))/100;
c = 1;
N = floor(n/2);

%generazione profilo simmetrico
xs = zeros(N-1,2);
for i=1:N-1
    xs(i,1) = 0.5-0.5*cos((2*i-1)/(2*N-1)*pi);
    xs(i,2) = 5*t*c*(0.2969*(xs(i,1)/c)^0.5 -0.1260*(xs(i,1)/c) -0.3516*(xs(i,1)/c)^2 +0.2843*(xs(i,1)/c)^3 -0.1036*(xs(i,1)/c)^4);
end
%xs(1,2) = 0;
xs(end,2) = 0;

%generazione linea camber
xc = zeros(N-1,2);
xc(:,1) = xs(:,1);
for i=1:N-1
    if xc(i,1) <= p*c
        xc(i,2) = m*xc(i,1)*(2*p-xc(i,1)/c)/(p*p);
    else
        xc(i,2) = m*(c-xc(i,1))*(1-2*p+xc(i,1)/c)/(1-p)^2;
    end
end

%generazione profilo
xt = xs(:,1);
xdorso = zeros(N-1,2);
xventre = zeros(N-1,2);
for i=1:N-1
    tantheta = 0;
    if xt(i,1) <= p*c
        tantheta = 2*m*(p-xt(i,1)/c)/(p*p);
    else
        tantheta = 2*m*(p-xt(i,1)/c)/(1-p)^2;
    end
    theta = atan(tantheta);
    xdorso(i,1) = xt(i,1) - xs(i,2)*sin(theta);
    xdorso(i,2) = xc(i,2) + xs(i,2)*cos(theta);
    xventre(i,1) = xt(i,1) + xs(i,2)*sin(theta);
    xventre(i,2) = xc(i,2) - xs(i,2)*cos(theta);
end

%costruzione lista punti
x = zeros(n,2);
x = zeros(n-1,2);
x(1:N-1,:) = flipud(xdorso);
x(N,:) = [0, 0];
%x(N+1:2*N-1,:) = [xventre(:,1), -xventre(:,2)];
x(N+1:2*N-1,:) = xventre;
